# -*- coding:Utf-8 -*-

"""
	Nom : selectrec03.py
	Adaptation du programme de démontration "rectangle_selector.py"
	fourni avec la documentation de Matplotlib
	Objectifs de la modification :
	- afficher deux images successivement
	- avec la souris sélectionner plusieurs zones rectangulaires successives et
	- récupérer leurs coordonnées
	- activer la sélection par lettre A
	- désactiver par lettre Q
	Modifications apportées par Alain Leraut - automne 2016
"""
from __future__ import print_function
from matplotlib.widgets import RectangleSelector
import numpy as np
import matplotlib.pyplot as plt


def coordonnees(click, relache):
    """  récupère le coin haut gauche du rectangle et le coin bas droite """
    x1, y1 = click.xdata, click.ydata
    x2, y2 = relache.xdata, relache.ydata
    print("(%3.2f, %3.2f) --> (%3.2f, %3.2f)" % (x1, y1, x2, y2))


def activer_la_selection(event):
    """"
	En appuyant sur la lettre Q (ou q) on désactive la possibilité de
	sélectionner. En appuyant la touche A (ou a) on réactive cette possibilité
    """
    print(' Key pressed.')
    if event.key in ['Q', 'q'] and activer_la_selection.RS.active:
        print(' RectangleSelector deactivated.')
        activer_la_selection.RS.set_active(False)
    if event.key in ['A', 'a'] and not activer_la_selection.RS.active:
        print(' RectangleSelector activated.')
        activer_la_selection.RS.set_active(True)

""" Mise en place de la première image et éléments de saisie """

fig, current_ax = plt.subplots()                    
print("\n      click  -->  release")
image 	= plt.imread('D.jpg')
plt.imshow(image)

activer_la_selection.RS = RectangleSelector(current_ax, coordonnees,
                                       drawtype='box', useblit=True,
                                       button=[1],  # seulement le bouton gauche
                                       minspanx=5, minspany=5,
                                       spancoords='pixels',
                                       interactive=True)
plt.connect('key_press_event',  activer_la_selection)
plt.show()		# Affichage de l'image et saise des clicks'

""" Mise en place de la première image et éléments de saisie """

fig, current_ax = plt.subplots()                    
print("\n      click  -->  release")
image2 	= plt.imread('E.jpg')
plt.imshow(image2)

activer_la_selection.RS = RectangleSelector(current_ax, coordonnees,
                                       drawtype='box', useblit=True,
                                       button=[1],  # seulement le bouton gauche
                                       minspanx=5, minspany=5,
                                       spancoords='pixels',
                                       interactive=True)
plt.connect('key_press_event',  activer_la_selection)
plt.show()
print("C'est tout fini !")

